/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.pi.PICodActions;
import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.client.PICodKeyDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;

public class PICodChange {
    private static final int NUM_VALID_PARMS = 8;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_operation;
    private String m_codType;
    private String m_codKey;
    private String m_quantityString;
    private String m_daysString;
    private int m_quantity;
    private int m_days;
    private HashMap m_validParms = new HashMap(17, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PICodActions m_codClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;
    private static final int INVALID_KEY_CONFIRMATION_ID = 512;
    private static final int CONVERT_TRIAL_CONFIRMATION_ID = 513;
    private static final int TRIAL_PROC_CONFIRMATION_ID = 514;
    private static final int TRIAL_MEM_CONFIRMATION_ID = 515;

    private PICodChange(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-o", null);
        this.m_validParms.put("-c", null);
        this.m_validParms.put("-k", null);
        this.m_validParms.put("-q", null);
        this.m_validParms.put("-d", null);
    }

    private void doActivateOperation() throws PIHscClientException {
        if ("onoff".equals(this.m_codType)) {
            if ("proc".equals(this.m_resourceType)) {
                this.m_codClient.manageOnOffProcessors(this.m_quantity, this.m_days);
            } else {
                Hashtable hashtable = this.m_codClient.getActivationIncrements();
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get("OnoffMemIncrement");
                int n = 1024;
                if (unsignedInt16 != null) {
                    n = unsignedInt16.intValue();
                }
                if (this.m_quantity % n != 0) {
                    String[] stringArray = new String[]{"-q", String.valueOf(n)};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "COD_MEM_QUANTITY_NOT_MULTIPLE", stringArray, null);
                }
                this.m_codClient.manageOnOffMemory(this.m_quantity, this.m_days);
            }
        } else {
            this.m_codClient.manageMeteredProcessors(this.m_quantity);
        }
    }

    private void doDeactivateOperation() throws PIHscClientException {
        if ("onoff".equals(this.m_codType)) {
            if ("proc".equals(this.m_resourceType)) {
                this.m_codClient.manageOnOffProcessors(0, 0);
            } else {
                this.m_codClient.manageOnOffMemory(0, 0);
            }
        } else if ("reserve".equals(this.m_codType)) {
            this.m_codClient.manageMeteredProcessors(0);
        } else {
            int n = "proc".equals(this.m_resourceType) ? 1 : 2;
            this.m_codClient.disableTrialResources(n);
        }
    }

    private int doEnterCodKeyOperation() throws PIHscClientException {
        PICodKeyDataBean pICodKeyDataBean = this.m_codClient.setCodKey(this.m_codKey);
        if (pICodKeyDataBean.getConfirmNeeded().booleanValue()) {
            int n = pICodKeyDataBean.getConfirmMsgID().intValue();
            String string = null;
            if (n == 512) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COD_INVALID_KEY_CONFIRMATION");
            } else if (n == 513) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COD_CONVERT_TRIAL_CONFIRMATION");
            } else if (n != 514 && n != 515) {
                throw new PIHscClientException("9003", "HSCCIMExceptionBundle", "9003", null, null);
            }
            boolean bl = true;
            if (n != 514 && n != 515) {
                this.m_out.print(pICodKeyDataBean.getReturnMessage());
                bl = PIHMCCommandUtils.doConfirmation(string);
            }
            if (bl) {
                pICodKeyDataBean = this.m_codClient.setCodKey(1, n, this.m_codKey);
            } else {
                if (n == 512) {
                    return 1;
                }
                pICodKeyDataBean = this.m_codClient.setCodKey(0, n, this.m_codKey);
            }
        } else if (!pICodKeyDataBean.getCodeCompleteSuccess().booleanValue()) {
            this.m_out.println(pICodKeyDataBean.getReturnMessage());
            return 1;
        }
        return 0;
    }

    private int performCommand() throws PIHscClientException {
        int n = 0;
        this.checkParameters();
        this.m_codClient = PICodActions.getInstance((PIHSCCECCIMClient)this.m_CECClient);
        if ("a".equals(this.m_operation)) {
            this.doActivateOperation();
        } else if ("d".equals(this.m_operation)) {
            this.doDeactivateOperation();
        } else {
            n = this.doEnterCodKeyOperation();
        }
        return n;
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (this.m_operation == null || !"a".equals(this.m_operation) && !"d".equals(this.m_operation) && !"e".equals(this.m_operation)) {
            string = string + ", -o";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ("a".equals(this.m_operation)) {
            if (this.m_codType == null || !"reserve".equals(this.m_codType) && !"onoff".equals(this.m_codType)) {
                String[] stringArray = new String[]{"-c"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            string = "";
            if ("reserve".equals(this.m_codType)) {
                if (this.m_resourceType == null || !"proc".equals(this.m_resourceType)) {
                    string = string + ", -r";
                }
            } else if (this.m_resourceType == null || !"proc".equals(this.m_resourceType) && !"mem".equals(this.m_resourceType)) {
                string = string + ", -r";
            }
            if ("onoff".equals(this.m_codType)) {
                try {
                    this.m_days = Integer.parseInt(this.m_daysString);
                    if (this.m_days <= 0) {
                        string = string + ", -d";
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = string + ", -d";
                }
            }
            try {
                this.m_quantity = Integer.parseInt(this.m_quantityString);
                if (this.m_quantity <= 0) {
                    string = string + ", -q";
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = string + ", -q";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            string = "";
            if ("reserve".equals(this.m_codType) && this.m_daysString != null) {
                string = string + ", -d";
            }
            if (this.m_codKey != null) {
                string = string + ", -k";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        } else if ("d".equals(this.m_operation)) {
            if (this.m_codType == null || !"reserve".equals(this.m_codType) && !"onoff".equals(this.m_codType) && !"trial".equals(this.m_codType)) {
                String[] stringArray = new String[]{"-c"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            if ("reserve".equals(this.m_codType)) {
                if (this.m_resourceType == null || !"proc".equals(this.m_resourceType)) {
                    String[] stringArray = new String[]{"-r"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if (this.m_resourceType == null || !"proc".equals(this.m_resourceType) && !"mem".equals(this.m_resourceType)) {
                String[] stringArray = new String[]{"-r"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            string = "";
            if (this.m_codKey != null) {
                string = string + ", -k";
            }
            if (this.m_quantityString != null) {
                string = string + ", -q";
            }
            if (this.m_daysString != null) {
                string = string + ", -d";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        } else {
            if (this.m_codKey == null || this.m_codKey.length() == 0) {
                String[] stringArray = new String[]{"-k"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            string = "";
            if (this.m_resourceType != null) {
                string = string + ", -r";
            }
            if (this.m_codType != null) {
                string = string + ", -c";
            }
            if (this.m_quantityString != null) {
                string = string + ", -q";
            }
            if (this.m_daysString != null) {
                string = string + ", -d";
            }
            if (string.length() > 0) {
                if (string.startsWith(", ")) {
                    string = string.substring(2, string.length());
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_operation = (String)hashMap.get("-o");
        this.m_codType = (String)hashMap.get("-c");
        this.m_codKey = (String)hashMap.get("-k");
        this.m_quantityString = (String)hashMap.get("-q");
        this.m_daysString = (String)hashMap.get("-d");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHCOD_HELP_2"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PICodChange pICodChange = new PICodChange(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pICodChange.m_validParms);
            pICodChange.mapParameters(hashMap);
            n = pICodChange.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        if (bl) {
            if (n == 0) {
                printStream.print('\u0000');
            } else {
                printStream.print('\u0001');
            }
        }
        return n;
    }
}

